 ; Ŀ
 ;   Daub - write a lisp to copy the current dimension style settings      
 ;   to another drawing.                                                   
 ;   Copyright 2003, 2010 by Rocket Software Ltd.                          
 ;   Rocket - the first software designed expressly to make the user       
 ;   look intelligent.                                                     
 ; 

 ; Ŀ
 ;   Dsc - utility - change dimscale without ending up with an overrride.  
 ;   Caution: makes all overrides part of the current style.               
 ; 
 (DEFUN C:DSC (/ discal discp stnam)
  (setvar "cmdecho" 0)
  (setq discal (getvar "dimscale"))
  (setq discp (getreal (strcat "Dimscale <" (itoa discal 2) ">: ")))
  (if discp (setq discal discp))
  (setq stnam (getvar "DIMSTYLE"))
  (command "dimstyle" "save" stnam "y")
 (princ))
 ; Ŀ
 ;   C:Dsc end.                                                            
 ; 

 ; Ŀ
 ;   Bottle - write a boxed file header.                                   
 ;   Arguments: Lognam - the filename to put the header in.                
 ;              Strlst - the list of strings to write, one per line.       
 ; 
 (DEFUN BOTTLE (lognam strlst / aa bb cc thestr newlst lognam fn)
  (setq aa "")
  (setq bb (strcat " ; " aa aa ""))
  (setq cc (strcat " ; " aa aa ""))
  (while (setq thestr (car strlst))
         (setq strlst (cdr strlst))
         (setq thestr (strcat " ;   " thestr))
         (while (< (strlen thestr) 76) (setq thestr (strcat thestr " ")))
         (setq thestr (strcat thestr ""))
         (setq newlst (append newlst (list thestr))))
  (setq fn (open lognam "w"))
  (princ bb fn)
  (while (setq thestr (car newlst))
         (setq newlst (cdr newlst))
         (princ (strcat "\n" thestr) fn))
  (princ (strcat "\n" cc "\n") fn)
  (close fn))
 ; Ŀ
 ;   Bottle end.                                                           
 ; 

 ; Ŀ
 ;   Subroutine Linne - make a command string from a list.                 
 ;   Arguments: Sub, a list of strings.                                    
 ;              Num, the position of this sublist in the master list.      
 ;              Len, the length of the master list.                        
 ;   Returns a string.                                                     
 ; 
 (DEFUN LINNE (sub num len / varnam vall linn)
  (if (= num 1)
      (setq varnam (strcat "  (command \"" (car sub) "\" "))
      (setq varnam (strcat "           \"" (car sub) "\" ")))
  (while (< (strlen varnam) 23) (setq varnam (strcat varnam " ")))
  (setq vall (cadr sub))
  (cond ((= (type vall) 'STR)
         (if (= vall "\"") (setq vall "\\\""))
         (setq vall (strcat "\"" vall "\"")))
        ((= (type vall) 'INT)
         (setq vall (itoa vall)))
        ((= (type vall) 'REAL)
         (setq vall (rtos vall 2 12))
         (if (= (substr vall 1 1) ".")
             (setq vall (strcat "0" vall)))))
  (setq linn (strcat varnam vall))
  (if (= num len) (setq linn (strcat linn ")")))
  (while (< (strlen linn) 40) (setq linn (strcat linn " ")))
 ; Ŀ
 ;   Finish and return the string.                                         
 ; 
 (strcat linn "; " (caddr sub)))
 ; Ŀ
 ;   Subroutine Linne end.                                                 
 ; 

 ; Ŀ
 ;   Narf - return a random string from an internal list.                  
 ; 
 (DEFUN NARF (/ s nnum mlst)
  (setq mlst (list
 "Laser printers are ok, but wouldn't you rather have a laser rifle?"
 "Why is alternating current still stubbornly analog?"
 "Why are pencils the only lubricant based drawing instrument?"
 "Why are there no air-cushion hover-mice?"
 "CD players have a laser.  Why can't they make toast?"
 "Always clocks - why did Dali never draw a 3.5\" disk?"
 "Why can't one get a cell phone with a dial?"
 "Why is there no carbonated glue?"
 "When will computer jumper cables be invented?"
 "Why can't you get a banana opener any more?"))
  (setq len (length mlst))
  (while (or (null nnum) (>= nnum len))
         (setq s (* (getvar "cdate") 10000000.0))
         (setq nnum (fix (* 100 (- s ( fix s))))))
 (nth nnum mlst))
 ; Ŀ
 ;   Narf end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Nopth - remove the path from a filename.                   
 ; 
 (DEFUN NOPTH (tt / pos)
  (setq pos (strlen tt))                          ; start at end of the string
  (while (< 0 pos)
         (if (or (= (substr tt pos 1) (chr 92))   ; if char = \
                 (= (substr tt pos 1) ":"))       ; if char = :
             (progn
                  (setq tt (substr tt (1+ pos)))  ; then set tt to all after
                  (setq pos 1)))                  ;  and set pos to first
         (setq pos (1- pos)))                     ; set pos to previous
 tt)
 ; Ŀ
 ;   Nopth end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Phrake - extract dimvars to a list with names.             
 ;   Takes no arguments, returns a list: ((name value) ...)                
 ; 
 (DEFUN PHRAKE (/ varlst num sub divar dimval nusub malist)
  (setq varlst '(("DIMADEC" "Angular decimal places")
                 ("DIMALT" "Alternate units selected")
                 ("DIMALTD" "Alternate unit decimal places")
                 ("DIMALTF" "Alternate unit scale factor")
                 ("DIMALTRND" "Alternate units rounding value")
                 ("DIMALTTD" "Alternate tolerance decimal places")
                 ("DIMALTTZ" "Alternate tolerance zero suppression")
                 ("DIMALTU" "Alternate units")
                 ("DIMALTZ" "Alternate unit zero suppression")
                 ("DIMANNO" "Is style annotative? (Read Only)")
                 ("DIMAPOST" "Prefix and suffix for alternate text")
                 ("DIMARCSYM" "Arc symbol display")
                 ("DIMASO" "Create dimensions as one entity - obsolete")
                 ("DIMASSOC" "Tie dimension objects to geometry")
                 ("DIMASZ" "Arrow size")
                 ("DIMATFIT" "Arrow and text fit")
                 ("DIMAUNIT" "Angular unit format")
                 ("DIMAZIN" "Angular zero supression")
                 ("DIMBLK" "Arrow block name")
                 ("DIMBLK1" "First arrow block name")
                 ("DIMBLK2" "Second arrow block name")
                 ("DIMCEN" "Center mark size")
                 ("DIMCLRD" "Dimension line and leader color")
                 ("DIMCLRE" "Extension line color")
                 ("DIMCLRT" "Dimension text color")
                 ("DIMDEC" "Decimal places")
                 ("DIMDLE" "Dimension line extension")
                 ("DIMDLI" "Dimension line spacing")
                 ("DIMDSEP" "Decimal separator")
                 ("DIMEXE" "Extension above dimension line")
                 ("DIMEXO" "Extension line origin offset")
                 ("DIMFIT" "Obsolete")
                 ("DIMFXL" "Total length of extension lines")
                 ("DIMFXLON" "Are extension lines fixed length?")
                 ("DIMJOGANG" "Angle of jog")
                 ("DIMLTEX1" "Extension line 1 linetype")
                 ("DIMLTEX2" "Extension line 2 linetype")
                 ("DIMLTYPE" "Dimension line linetype")
                 ("DIMFRAC" "Fraction format")
                 ("DIMGAP" "Gap from dimension line to text")
                 ("DIMJUST" "Justification of text on dimension line")
                 ("DIMLDRBLK" "Leader block name")
                 ("DIMLFAC" "Linear unit scale factor")
                 ("DIMLIM" "Generate dimension limits")
                 ("DIMLUNIT" "Linear unit format")
                 ("DIMLWD" "Dimension line and leader lineweight")
                 ("DIMLWE" "Extension line lineweight")
                 ("DIMPOST" "Prefix and suffix for dimension text")
                 ("DIMRND" "Rounding value")
                 ("DIMSAH" "Separate arrow blocks")
                 ("DIMSCALE" "Overall scale factor")
                 ("DIMSD1" "Suppress the first dimension line")
                 ("DIMSD2" "Suppress the second dimension line")
                 ("DIMSE1" "Suppress the first extension line")
                 ("DIMSE2" "Suppress the second extension line")
                 ("DIMSHO" "Update text while dimension is dragged")
                 ("DIMSOXD" "Suppress outside dimension lines")
                 ("DIMSTYLE" "Current dimension style (read-only)")
                 ("DIMTAD" "Place text above the dimension line")
                 ("DIMTDEC" "Tolerance decimal places")
                 ("DIMTFAC" "Tolerance text height scaling factor")
                 ("DIMTIH" "Text inside extensions is horizontal")
                 ("DIMTIX" "Place text inside extensions")
                 ("DIMTM" "Minus tolerance")
                 ("DIMTMOVE" "Text movement")
                 ("DIMTOFL" "Force line inside extension lines")
                 ("DIMTOH" "Text outside horizontal")
                 ("DIMTOL" "Tolerance dimensioning")
                 ("DIMTFILL" "Use dimension text backgrounds")
                 ("DIMTFILLCLR" "Dimension text background colour")
                 ("DIMTOLJ" "Tolerance vertical justification")
                 ("DIMTP" "Plus tolerance")
                 ("DIMTSZ" "Tick size")
                 ("DIMTVP" "Text vertical position")
                 ("DIMTXSTY" "Text style")
                 ("DIMTXT" "Text height")
                 ("DIMTZIN" "Tolerance zero suppression")
                 ("DIMUNIT" "Obsolete")
                 ("DIMUPT" "User positioned text")
                 ("DIMZIN" "Zero suppression")))
 ; Ŀ
 ;   Get a value for each dimvar, save to a list.                          
 ; 
  (setq num 0)
  (while (setq sub (nth num varlst))
         (setq divar (car sub))
         (setq num (1+ num))
         (if (setq dimval (getvar divar))
 ; Ŀ
 ;   If the variable was found then return a list of the the variable      
 ;   name, value, and description.                                         
 ; 
             (progn
 ; Ŀ
 ;   Special cases are beginning to creep in - Dimjogang is returned in    
 ;   degrees unless you use (getvar ...) in which case it is in radians.   
 ;   The command line version won't accept a value which isn't between     
 ;   5 and 90 inclusive.                                                   
 ; 
                  (if (= (strcase divar) "DIMJOGANG")
                      (progn
                           (setq dimval (* 180 (/ dimval pi)))
                           (cond ((> dimval 90.0)
                                  (setq dimval 90))
                                 ((< dimval 5)
                                  (setq dimval 5)))))
                  (setq nusub (list divar dimval (cadr sub)))
                  (setq malist (cons nusub malist)))
 ; Ŀ
 ;   If there was no such variable in the current version then return      
 ;   the variable name and description prefaced with a semicolon.          
 ; 
             (progn
                  (setq nusub (list ";" divar (cadr sub)))
                  (setq malist (cons nusub malist)))))
 (reverse malist))
 ; Ŀ
 ;   Phrake end.                                                           
 ; 

 ; Ŀ
 ;   Daub.                                                                 
 ; 
 (DEFUN C:DAUB (/ lspnam prognm aa bb cc dd dimlst len dimstl fn stnam num
                                                                   sub linn)
  (setvar "cmdecho" 0)
 ; Ŀ
 ;   Get the name for the new routine.                                     
 ; 
  (setq lspnam (getfiled "Dimension Updater Routine Name" "" "lsp" 1))
 ; Ŀ
 ;   Make the program name.                                                
 ; 
  (setq prognm (nopth lspnam))  
  (if (= (substr prognm (- (strlen prognm) 3) 1) ".")
      (setq prognm (substr prognm 1 (- (strlen prognm) 4))))
 ; Ŀ
 ;   Make up the text lines for the header.                                
 ; 
  (setq aa (strcat (strcase (substr prognm 1 1))
                   (strcase (substr prognm 2) t)
                   " - update a dimstyle."))
  (setq bb (strcat "Made in Acad " (getvar "acadver")
                   " - dimvars may differ in other releases."))
  (setq cc "This program was written by Rocket Software's Daub.lsp")
  (setq dd (narf))
 ; Ŀ
 ;   Get the list of values (assume that the desired dimstyle is current.) 
 ; 
  (setq dimlst (phrake))
  (setq len (length dimlst))
 ; Ŀ
 ;   Set the dimstyle in the data to be the current style.                 
 ; 
  (setq dimstl (cadr (assoc "DIMSTYLE" dimlst)))
 ; Ŀ
 ;   Write the routine.                                                    
 ;   First call Bottle to write the header.                                
 ; 
  (bottle lspnam (list aa bb cc dd))
 ; Ŀ
 ;   And add the code.                                                     
 ; 
  (setq fn (open lspnam "a"))
  (write-line (strcat " (DEFUN C:" (strcase prognm) " (/ stnam)") fn)
  (write-line "  (setvar \"cmdecho\" 0)" fn)
  (write-line "  (command \"undo\" \"be\")" fn)
  (write-line (strcat "  (setq stnam \"" dimstl "\")") fn)
  (setq num 0)
  (while (setq sub (nth num dimlst))
         (setq num (1+ num))
         (cond ((= (car sub) ";")
                (setq linn (strcat " ; No such variable as " (cadr sub)))
                (while (< (strlen linn) 40) (setq linn (strcat linn " ")))
                (setq linn (strcat linn "; " (caddr sub)))
                (write-line linn fn))
 ; Ŀ
 ;   Comment out Dimscale, which will probably differ between drawings.    
 ;   Also Dimanno, which is read-only.                                     
 ; 
               ((member (car sub) '("DIMSCALE" "DIMANNO"))
                (setq linn (linne sub num len))
                (setq linn (strcat " ; " (substr linn 4)))
                (write-line linn fn))
 ; Ŀ
 ;   Dimstyle is taken care of by itself, not in this loop.                
 ;   So the rest of this odd Cond is the default case: write a data line.  
 ; 
               ((/= (car sub) "DIMSTYLE")
                (setq linn (linne sub num len))
                (write-line linn fn))))
 ; Ŀ
 ;   Name the new style after the original, overwrite the existing one.    
 ; 
  (write-line "  (if (tblsearch \"dimstyle\" stnam)" fn)
  (write-line "      (command \"dimstyle\" \"save\" stnam \"y\")" fn)
  (write-line "      (command \"dimstyle\" \"save\" stnam))" fn)
  (write-line "  (command \"undo\" \"end\")" fn)
  (write-line " (princ))" fn)
  (close fn)
 (princ))